/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.bedspreads;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.bedspreads.client.renderer.DecoratedBedTileEntityRenderer;
import top.theillusivec4.bedspreads.common.DecoratedBedsRegistry;
import top.theillusivec4.bedspreads.mixin.MixinPointOfInterestType;

@Mod(value="bedspreads")
public class BedspreadsMod {
    public static final String MODID = "bedspreads";

    public BedspreadsMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent evt) {
        evt.enqueueWork(() -> {
            MixinPointOfInterestType poit = (MixinPointOfInterestType)PoiType.f_27346_;
            Set<BlockState> states = DecoratedBedsRegistry.DECORATED_BED_BLOCK.m_49965_().m_61056_().stream().filter(state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD).collect(Collectors.toSet());
            states.forEach(state -> MixinPointOfInterestType.getPoit().put((BlockState)state, PoiType.f_27346_));
            states.addAll(poit.getBlockStates());
            poit.setBlockStates((Set<BlockState>)ImmutableSet.copyOf(states));
        });
    }

    @Mod.EventBusSubscriber(modid="bedspreads", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
            evt.registerBlockEntityRenderer(DecoratedBedsRegistry.DECORATED_BED_TE, DecoratedBedTileEntityRenderer::new);
        }

        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre evt) {
            if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
                for (BannerPattern pattern : BannerPattern.values()) {
                    evt.addSprite(new ResourceLocation(BedspreadsMod.MODID, "entity/" + pattern.m_58572_()));
                }
                evt.addSprite(new ResourceLocation(BedspreadsMod.MODID, "entity/bed_base"));
            }
        }
    }
}

